/*************************************************************************
 *
 * Copyright (c) 1997-2001 Jtel Corporation or its subsidiaries.
 * All rights reserved.
 *
 * DESC:
 *
 ************************************************************************/
#include "AppMain.h"



/*************************************************************************
 * Function Declarations
 ************************************************************************/
extern STATUS AppMain(U32 cmd, P_U32 param);
    static STATUS CommandProcessing(U32 cmd, P_U32 param);
    static bool ApplicationHandleEvent(EventStruct* e);
    static bool InitApp(void);
    static bool DeinitApp(void);



/*************************************************************************
 * Functions
 ************************************************************************/

bool InitApp(void)
{
    if(!FormGo(Form_Main_1000))
        return FALSE;

    return TRUE;
}


bool DeinitApp(void)
{
    return TRUE;
}


STATUS CommandProcessing(U32 cmd, P_U32 param)
{
    STATUS ret = CVOS_NOTHING;

    switch(cmd)
    {
        case REQ_INITDB:
			//EFBSetAppStatusInBackupList(GetCurAppID(), TRUE, TRUE, TRUE);
            break;
        case REQ_INITWARMRESET:
            break;
        case REQ_VIEWFINDDATA:
            break;
        case REQ_DBTABLENUM:
            //*((P_U16)param) = 1;
            break;
        case REQ_DBTABLENAME:
            //strcpy(((P_CMDREQTBLNAME)param)[0].pTableName, TABLE_NAME);
			//((P_CMDREQTBLNAME)param)[0].Type = TYPE_USERTABLE;
            break;
        case REQ_DBTABLENAMEFORIR:
            break;
        case REQ_GLOBALFIND:
            break;
        case REQ_MATCHSTR:
            break;
        case REQ_UNINSTALL:
            break;
    }

    return ret;
}


bool ApplicationHandleEvent(EventStruct* e)
{
    bool handled = FALSE;

    switch (e->EventType)
    {
        case FORMLOADEVENT:
            FormNew(e->ObjectID);

            switch (e->ObjectID)
            {
                case Form_Main_1000:
                	frmMainOnLoad();
                    FormSetEventHandler(frmMainHandleEvent);
                    FormDraw();
                    handled = TRUE;
                    break;
            }
            break;

        case FORMUNLOADEVENT:
            FormFree();
            handled = TRUE;
            break;
    }

    return handled;
}


STATUS AppMain(U32 cmd, P_U32 param)
{
    EventStruct event;

    if ( cmd != NORMAL_START )
        return ( CommandProcessing(cmd, param));

    if( !InitApp() )
        return CVOS_ERROR;

    do
    {   /* EventLoop - Listen Event */
        while(!EventGet(&event)); /* NULL LOOP */

        if(!SystemHandleEvent(&event))
            if(!MenuHandleEvent(&event))
                if(!ApplicationHandleEvent(&event))
                    FormDispatchEvent(&event);
    } while (event.EventType != APPSTOPEVENT);

    if( !DeinitApp() )
        return CVOS_ERROR;

    return CVOS_OK;
}
