#ifndef __lib_CircularQueue_h
#define __lib_CircularQueue_h

#include <MyTypes.h>


/*************************************************************************
 * Macros and Constants
 ************************************************************************/
#define CqIsEmpty(Z)    ((Z)->Front == (Z)->Rear)
#define CqIsFull(Z)     (((Z)->Rear+1) % (Z)->Size == (Z)->Front)
#define CqClear(Z)      ((Z)->Front = (Z)->Rear = 0)


/*************************************************************************
 * User Defined Types and Structures
 ************************************************************************/
typedef struct {
    bool  ExistingBuf;
    uint  Front; // out
    uint  Rear; // in
    uint  Size;
    char* Buf;
} TCircularQueue;


/*************************************************************************
 * Function Declarations
 ************************************************************************/
void  CqAssign(TCircularQueue* dst, TCircularQueue* src);
void  CqCopy(TCircularQueue* dst, TCircularQueue* src);
void  CqInit(TCircularQueue* q, uint size);
void  CqInitWithExistingBuf(TCircularQueue* q, void* buf, uint size);;
void  CqFree(TCircularQueue* q);
uint  CqUsedSize(TCircularQueue* q);
uint  CqUnusedSize(TCircularQueue* q);
void  CqSync(TCircularQueue* q, uint front, uint rear);
bool  CqPutByte(TCircularQueue* q, char data);
bool  CqGetByte(TCircularQueue* q, char* data);
void  CqPutBuf(TCircularQueue* q, void* buf, uint bufsize, uint* realsize);
void  CqGetBuf(TCircularQueue* q, void* buf, uint bufsize, uint* realsize);
void  CqMoveBuf(TCircularQueue* q1, TCircularQueue* q2, uint size, uint* realsize);
bool  CqPutBufAll(TCircularQueue* q, void* buf, uint bufsize);
bool  CqGetBufAll(TCircularQueue* q, void* buf, uint bufsize);
bool  CqMoveBufAll(TCircularQueue* q1, TCircularQueue* q2);
char* CqParse(TCircularQueue* q, char delimitator);
char* CqParse2(TCircularQueue* q, char* delimitators, int num);

#endif
