/*************************************************************************
 *
 * Copyright (c) 1997-2001 Jtel Corporation or its subsidiaries.
 * All rights reserved.
 *
 * DESC:
 *
 ************************************************************************/
#include "AppMain.h"

char caption[256];
char msg[256];

/*************************************************************************
 * Function Declarations
 ************************************************************************/
extern bool frmMainHandleEvent(EventStruct* e);
	extern void frmMainOnLoad(void);
	static void btnStartOnClick(void);



/*************************************************************************
 * Functions
 ************************************************************************/

void frmMainOnLoad(void)
{
	ComponentStruct *csp;

	memset( caption, 0, 256 );
	strcpy( caption, "caption" );
	csp = FormGetComponentPtr( Main_Edit_caption_1036 );
	FieldEditSetBuffer(  csp, caption, 256 );
	
	memset( msg, 0, 256 );
	strcpy( msg, "msg" );
	csp = FormGetComponentPtr( Main_Edit_msg_1042 );
	FieldEditSetBuffer(  csp, msg, 256 );
}

bool GetComponentSelected( U16 ID )
{
	ComponentStruct *csp;
	
	csp = FormGetComponentPtr( ID );
	return csp->Selected;
}

void btnDoOnClick(void)
{
	int nMessageKindType;
	int nButtonFlag;
	
	if( GetComponentSelected( Main_RadioBtn_MK_INFORMATION_1003 ) )
	 nMessageKindType = MK_INFORMATION;
	else if( GetComponentSelected( Main_RadioBtn_MK_WARNING_1006 ) )
		nMessageKindType = MK_WARNING;	
	else if( GetComponentSelected( Main_RadioBtn_MK_ERROR_1009 ) )
		nMessageKindType = MK_ERROR;	
	else if( GetComponentSelected( Main_RadioBtn_MK_FATAL_1012 ) )
		nMessageKindType = MK_FATAL;	
	else if( GetComponentSelected( Main_RadioBtn_MK_QUERY_1015 ) )
		nMessageKindType = MK_QUERY;	
	
	nButtonFlag = 0;
	if( GetComponentSelected( Main_CheckBtn_MSGBOX_OK_1021 ) )
	 	nButtonFlag |= MSGBOX_OK;
	if( GetComponentSelected( Main_CheckBtn_MSGBOX_CANCEL_1024 ) )
		nButtonFlag |= MSGBOX_CANCEL;	
	if( GetComponentSelected( Main_CheckBtn_MSGBOX_YES_1027 ) )
		nButtonFlag |= MSGBOX_YES;	
	if( GetComponentSelected( Main_CheckBtn_MSGBOX_NO_1030 ) )
		nButtonFlag |= MSGBOX_NO;	
	if( GetComponentSelected( Main_CheckBtn_MSGBOX_HELP_1033 ) )
		nButtonFlag |= MSGBOX_HELP;	

	MsgBoxDo( nMessageKindType, caption, msg, nButtonFlag );
}


bool frmMainHandleEvent(EventStruct* e)
{
	bool handled = FALSE;
	
	switch (e->EventType)
	{
		case COMPONENTSELECTEVENT:
			switch (e->ObjectID)
			{
				case Main_Button_do_1018:
					btnDoOnClick();
					handled = TRUE;
					break;
			}
			break;
	}
	return handled;
}
