/*
	RaDlg.c
*/

#include "RaApp.h"

bool bRAtwo = false;
unsigned long timerId;

void RaAppAbout( void )
{
	MsgBoxDo( MK_INFORMATION, "RA Simple Date/Time", "RA Simple Date/Time\nDesigned for RA Launcher", MSGBOX_OK );
}

DBoxDrawCallbackFuncPtr RaDlgDrawCallback( void )
{ 
	ComponentStruct* csp;
	Timestamp timestamp;
	static U8 datetimebuf[50];
	
	DateTimeRead( &(timestamp.year), &(timestamp.month), &(timestamp.date), &(timestamp.hour), &(timestamp.minute), &(timestamp.second) );
	
	SnPrintf( datetimebuf, 50, "%04d/%02d/%02d %02d:%02d:%02d", timestamp.year, timestamp.month, timestamp.date, timestamp.hour, timestamp.minute, timestamp.second );	
	csp = FormGetComponentPtr( Main_Label_time_1015 );
	LabelSetLabel( csp, datetimebuf, true );
}

bool RaDlgHandleEvent( EventStruct* e )
{
	bool handled = FALSE;
	
	switch( e->EventType )
	{
		case COMPONENTSELECTEVENT:
			switch( e->ObjectID )
			{
				case Main_Button_Info_1009:
					RaAppAbout();
				  break;

				case Main_Button_Close_1003:
					EventPutDBoxCloseEvent();
				  break;
			}
			break;
		
		case TIMEOUTEVENT:
			if( e->EventData.TimeoutEvent.timerId == timerId ) 
			{
				RaDlgDrawCallback();
			}
			break;

		case BUTTONUPEVENT :
		case BUTTONREPEATEVENT :
			switch( e->EventData.ID )
			{
				case ENTER_BTN:
				case JOGUP_BTN:
				case BACK_BTN:
					EventPutDBoxCloseEvent();
					break;
			}
			break;

		case OFFSITEDOWNEVENT:
		case OFFSITEUPEVENT:
		case OFFSITEDRAGEVENT:
			EventPutDBoxCloseEvent();
			break;
	}
	
	return handled;
}

void RaDlgLoad( void )
{
	//* ߺ
	if( bRAtwo )
		return;
		
	bRAtwo = true;

	TimeoutId((P_U32)&timerId, (unsigned long)1000, (unsigned short)TRUE);
	
	DBoxNew( Form_Main_1000 );
	FormSetEventHandler( RaDlgHandleEvent );
	DBoxSetDrawCallback( (DBoxDrawCallbackFuncPtr)RaDlgDrawCallback );
	
	DBoxDo( Form_Main_1000 );
	FormFree();
	
	KillTimerId((unsigned long)timerId);

	bRAtwo = false;

}
